﻿$(function() {
	creatGrid();
	//附件分类
	$('#classifyCombx').combotree({
		multiple : false,
		checkbox : false,
		lines : true,
		animate : true,
		editable : false,//不可编辑
		onHidePanel : getChildren,//获取子节点
		url : baseUrl + '/admin/B020/listAccessoriesClassifyTree.html',
		required : false
	});
});
/**
 * easyUi dataGrid注册方式说明，防止二次渲染 class注册方式一般是为了初始化属性，js方式则属性和事件都可初始化
 * 但是不管是class方式还是js方式注册组件，每次注册，只要被设置过url属性就会做请求。
 * 所以在不可避免要使用js方式注册的情况下，索性就不要使用class方式注册了。
 */
function creatGrid() {
	$('#itemList').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : false,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据sort。
		pagination : true,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 10,// 每页显示的记录条数，默认为10
		pageList : [ 10, 20, 50 ],// 每页显示多少行
		rownumbers : true,// 行号
		url : baseUrl + '/admin/C030/listAccessoriess.html',
		toolbar : '#tbar',
		frozenColumns : [ [ {
			field : 'select',
			title : 'select',
			width : 50,
			checkbox : true
		} ] ],
		columns : [ [ {
			field : 'accessoriesName',
			title : "Accessories Name",
			width : 120,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'type',
			title : 'classify Name',
			width : 45,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'classifyName',
			title : 'classify Name',
			width : 80,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'userName',
			title : 'user name',
			width : 80,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'updDate',
			title : 'updated Date',
			width : 80,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'center',
			formatter : fmdate
		}, {
			field : 'manage',
			title : 'manage',
			align : 'center',
			halign: 'center',
			width : 80,
			formatter : operate
		} ] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {
			$('.edit_accessories').linkbutton({
				iconCls : 'icon-edit',
				plain : true
			});
			$('.drop_courseware').linkbutton({
				iconCls : 'icon-no',
				plain : true
			});
		}
	});

}
//sort
function datasort(a, b) {
	return (a > b ? 1 : -1);
}
// 操作
function operate(value, rowData, rowIndex) {
	var id = rowData.courseAccessoriesId;
	return "<a href='javascript:void(0);' onclick='updInfo(" + id+ ");' class='edit_accessories'>edit </a>" +
			"<a href='javascript:void(0);' onclick='delById("+ id + ");' class='drop_courseware' >delete</a>";
}

// 打开页面
function add() {
	window.parent.openTab("Add Accessories", baseUrl + "/admin/C030/manageAddAccessories.html");
}
// 格式化日期
function fmdate(value, rowData, rowIndex) {
	if (value != null && value != '') {
		return fmtLongDate(new Date(value));
	}
	return "";
}
function find() {
	// 附件名称
	var coursewareName = $("#name").val();
	// 附件分类
	//var coursewareClassify = $("#classifyCombx").val();

	var coursewareClassify = classifyids;
	var dateStart = $("#updateTimeStart").datebox("getValue");
	if(dateStart && dateStart!=""){
		dateStart=dateStart+" 00:00:00";
	}
	var dateEnd = $("#updateTimeEnd").datebox("getValue");
	if(dateEnd && dateEnd!=""){
		dateEnd=dateEnd+" 23:59:59";
	}

	$('#itemList').datagrid('load', {
		coursewareName : coursewareName,
		classifyid : coursewareClassify,
		dateStart : dateStart,
		dateEnd : dateEnd
	});

}
// 刷新
function reloadGrid() {
	$('#itemList').datagrid('clearSelections');
	$('#itemList').datagrid('reload');
}

// 删除附件
function del() {
	var items_id = new Array();
	var items = $('#itemList').datagrid('getSelections');
	if (items.length <= 0) {
		$.messager.alert('Hint', 'Please select the accessories need deleted', 'info');
		return;
	}
	$.messager.confirm('delete Hint', 'Make sure to delete the selected accessories?</br></br><input type="checkbox" id="yuanwenjian" name="checkbox1" value="1" /> Delete the local source file', function(r) {
		if (r) {
			var str=document.getElementsByName("checkbox1");
			var objarray=str.length;
			var chestr=0;
			for (var i=0;i<objarray;i++) {
			 if(str[i].checked == true)
			 {
			  chestr =str[i].value;
			 }
			}
			// 获取选中附件的ID，并组成集合
			for ( var i = 0; i < items.length; i++) {
				items_id.push(items[i].courseAccessoriesId);
			}
			$.post(baseUrl + "/admin/C030/removeAccessories.html", {
				aid : items_id,
				typeid:chestr
			}, function(data) {
				if (data > 0) {
					msgShow('Delete success!');
					reloadGrid();
				}else if(data = -1){
					msgShow('delete failure，accessories are being used');
					reloadGrid();
				} else {
					msgShow('delete failure，Please try again later');
					reloadGrid();
				}
			}, "json");
		}
	});
}

//根据ID删除
function delById(id) {
	var items_id = new Array();
	items_id.push(id);
	$.messager.confirm('delete hint', 'Make sure to delete this accessories?</br></br><input type="checkbox" id="yuanwenjian" name="checkbox1" value="1" /> Delete the local source file', function(r) {
		if (r) {
			var str=document.getElementsByName("checkbox1");
			var objarray=str.length;
			var chestr=0;
			for (var i=0;i<objarray;i++) {
			 if(str[i].checked == true)
			 {
			  chestr =str[i].value;
			 }
			}
			$.post(baseUrl + "/admin/C030/removeAccessories.html", {
				aid :items_id,
				typeid:chestr
			}, function(data) {
				if (data > 0) {
					msgShow('Delete success!');
					reloadGrid();
				}else if(data = -1){
					msgShow('delete failure，accessories are being used');
					reloadGrid();
				}else {
					msgShow('delete failure，Please try again later');
					reloadGrid();
				}
			}, "json");
		}
	});
}
/**
 * 编辑附件
 */
function updInfo(id){
	window.parent.closeTabByTitle("Edit Accessories");
	window.parent.openTab("Edit Accessories", baseUrl + "/admin/C030/manageGetUpdAccessories.html?id="+id);
}
var classifyids="";//全局变量
function getChildren() {
	var grouptree = $('#classifyCombx').combotree('tree');//对应combotreeID
	var n = grouptree.tree('getSelected');
	var ids=n.id;
	var items=n.children;
	if(items!=null){
		var children = grouptree.tree('getChildren', n.target);
		for(var i=0;i<children.length;i++){
			var item=children[i];
			ids=ids+","+item.id;
		}
	}
	classifyids=ids;//赋值给全局变量 记录所选分类全部ID
}